local convoy_to_copy = null

function init(player)
{
	return true
}

function exit(player)
{
	return true
}

function find_convoy(tile) {
	local convoy_array = tile.get_convoys()
	if(convoy_array.len()==0) {
		return "convoy is not found on the tile."
	}
	convoy_to_copy = convoy_array[0]
	return "Please select the depot to copy."
}

function range_gen(n) {
	for(local i=0; i<n; i++) {
		yield i
	}
	return null
}

function copy_convoy(tile, player) {
	local depot = tile.get_depot()
	if(depot==null || !depot.is_valid()) {
		return "depot is not found on the tile."
	}
	if(depot.get_owner().get_name()!=player.get_name()) {
		return "This depot is not yours."
	}
	if(depot.get_waytype()!=convoy_to_copy.get_waytype()) {
		return "Depot type is different."
	}
	depot.append_vehicle(player, convoy_x(player), convoy_to_copy.get_vehicles()[0])
	local cnv_list = depot.get_convoy_list()
	local cnv = cnv_list[cnv_list.len()-1]
	foreach(idx in range_gen(convoy_to_copy.get_vehicles().len()-1)) {
		if(idx+1==cnv.get_vehicles().len()) {
			// This line may append more than one vehicles.
			depot.append_vehicle(player, cnv, convoy_to_copy.get_vehicles()[idx+1])
		}
	}
	convoy_to_copy = null
	return "convoy was successfully copied."
}

function work(player, pos) {
	local tile = tile_x(pos.x, pos.y, pos.z)
	if(convoy_to_copy == null) {
		return find_convoy(tile)
	} else {
		return copy_convoy(tile, player)
	}
}
