//使用する線路を定義する座標範囲
local front_region = [[0,2,-20], [3,2,20]]
local back_region = [[0,1,-20], [3,1,20]]
//ここまで

include("lib_obj_finder_v2")

function get_region_text(r) {
  return "("+r[0][0]+","+r[0][1]+","+r[0][2]+"), ("+r[1][0]+","+r[1][1]+","+r[1][2]+")"
}

class hm_slope {
  N1 = 4
  N2 = 8
  S1 = 36
  S2 = 72
  E1 = 28
  E2 = 56
  W1 = 12
  W2 = 24
  UP = 82
  DOWN = 83
}

function get_slope_offset(pos, end) {
  local slp = tile_x(pos.x, pos.y, pos.z).get_slope()
  if(slp==slope.flat) {
    return 0
  }
  local mp = (slp>hm_slope.S1) ? 2 : 1 //緩急坂をいっしょに扱う
  if(slp/mp==hm_slope.N1) {
    return ((pos.y>end.y) ? -1 : 1) * mp
  }
  else if(slp/mp==hm_slope.S1) {
    return ((pos.y>end.y) ? 1 : -1) * mp
  }
  else if(slp/mp==hm_slope.E1) {
    return ((pos.x>end.x) ? 1 : -1) * mp
  }
  else if(slp/mp==hm_slope.W1) {
    return ((pos.x>end.x) ? -1 : 1) * mp
  }
  return 10 // invalid slope
}

// p1->p2とp2->p3の方角が同じか？
function is_ribi_same(p1, p2, p3) {
  local dx1 = p2.x-p1.x>0 ? 1 : p2.x==p1.x ? 0 : -1
  local dx2 = p3.x-p2.x>0 ? 1 : p3.x==p2.x ? 0 : -1
  local dy1 = p2.y-p1.y>0 ? 1 : p2.y==p1.y ? 0 : -1
  local dy2 = p3.y-p2.y>0 ? 1 : p3.y==p2.y ? 0 : -1
  return dx1==dx2 && dy1==dy2
}

function get_straight_way(start, end, concatenate) {
	local pos = coord3d(start.x, start.y, start.z)
	local route = [coord3d(pos.x, pos.y, pos.z)]
	while(pos.x!=end.x || pos.y!=end.y) {
    local offset = get_slope_offset(pos, end)
    pos.z += ((offset>0) ? offset : 0)
		// shortest way
		if(abs(pos.x-end.x)>=abs(pos.y-end.y)) {
			pos.x = (pos.x>end.x) ? pos.x - 1 : pos.x + 1
		}
		else {
		 	pos.y = (pos.y>end.y) ? pos.y - 1 : pos.y + 1
		}
    offset = get_slope_offset(pos, end)
    if(offset>2) {
      // invalid slope
      return []
    }
    pos.z += ((offset<0) ? offset : 0)
    
    local l = route.len()
    if(concatenate && l>=2 && is_ribi_same(route[l-2], route[l-1], pos)) {
      // 連結
      route[l-1] = coord3d(pos.x, pos.y, pos.z)
    } else {
      // 追加
      route.append(coord3d(pos.x, pos.y, pos.z))
    }
	}
	return route
}

function is_front(route, idx) {
	local dc = coord3d(0,0,0)
	if(idx > 0) {
		dc += (route[idx] - route[idx-1])
	}
	if(idx < route.len()-1) {
		dc += (route[idx+1] - route[idx])
	}
	return dc.x==0 ? (dc.y > 0) : (dc.x < 0)
}

function do_work(player, start, end) {
  // descの取得とエラー処理
  local regions = [front_region, back_region]
  local descs = [] // front, back
  local wayobj_descs = []
  foreach(r in regions) {
    local d = ObjFinder(player, r).findWay()
    if(d==null) {
      return "Way is not found between " + get_region_text(r)
    }
    descs.append(d)
    wayobj_descs.append(ObjFinder(player, r).findWayObj())
  }
  
  //1マスずつfront/backを判定しながら建設
	local route = get_straight_way(start, end, true)
	for(local i = 0; i < route.len()-1; i++) {
		local desc = is_front(route, i) ? descs[0] : descs[1]
		local err = command_x.build_way(player, route[i], route[i+1], desc, true)
    if(err!=null) {
      return err
    }
    local wod = is_front(route, i) ? wayobj_descs[0] : wayobj_descs[1]
    local zof = desc.get_system_type()==st_elevated ? coord3d(0,0,2) : coord3d(0,0,0)
    if(wod!=null) {
      command_x.build_wayobj(player, route[i]+zof, route[i+1]+zof, wod)
    }
	}
}

function mark_tiles(player, start, end)
{
	local route = get_straight_way(start, end, false)
	foreach (p in route) {
		mark_tile(p)
	}
}
