// 寿命となる積算距離を定数として定義
const retire_distance_car = 50000;      // 自動車
const retire_distance_train = 150000;   // 鉄道
const retire_distance_monorail = 100000;// モノレール
const retire_distance_tram = 100000;    // 市電
const display_restlife_less_than = 24;  // この数字未満の残り月間の編成が表示されます

// 本体
function work(pl, pos) {
    local list = world.get_convoy_list(); //マップ内全会社の編成を取得します
    foreach (convoy in list){
        local line = convoy.get_line();
        local cnvpos = convoy.get_pos();
        if(line){
            local restmonth = calculateRemainderMonth(convoy,line);
            if(restmonth < display_restlife_less_than){
                local message = createMessage(convoy,line,restmonth);
                if(message){
                    gui.add_message_at(pl, message, cnvpos);
                }
                else{
                }
            }
        }
    }
    return null; 
}

// メッセージ表示エンジン
function createMessage(convoy,line,restmonth){
    local cn = convoy.get_name();
    local ln = line.get_name();
    local wt = line.get_waytype();
    local wtstring = "";
    // display waytype
    switch (wt){
        case 1: wtstring = "Car"        ; break ;
        case 2: wtstring = "Train"      ; break ;
        case 5: wtstring = "Monorail"   ; break ;
        case 7: wtstring = "Tram"       ; break ;
        default: break;
    }
    // result
    return cn + "\n"+
    	ln + "\n" +
        "車両の種類 = " + wtstring + "\n" +
        "走行距離超過まで : " + restmonth +" ヶ月\n"; 
}

// 積算距離到達までの残り月間判定します
function calculateRemainderMonth(convoy,line){
    local wt =line.get_waytype(); 
    switch (wt){
        case 1 : break; // wt=1 is car
        case 2 : break; // wt=2 is train
        case 5 : break; // wt=5 is monorail
        case 7 : break; // wt=7 is tram
        default: return 32767; //if the waytype is one of the others,sets too long month
    }
    // declear settings
    local td = convoy.get_distance_traveled_total();
    local dis_pm = 0; //distance per month

    for(local i=1;i<12;i++){
        if(!convoy.get_traveled_distance()[i]){
            return 32767;
        }
    	dis_pm += convoy.get_traveled_distance()[i];
    }
    dis_pm /= 11;
    local remainder_month_from_distance = 0;
    switch (wt){
        case 1: // wt=1 is car
        remainder_month_from_distance = (retire_distance_car - td ) / dis_pm;
        break;
        case 2: // wt=2 is train
        remainder_month_from_distance = (retire_distance_train - td ) / dis_pm;
        break;
        case 5: // wt=5 is monorail
        remainder_month_from_distance = (retire_distance_monorail - td ) / dis_pm;
        break;
        default: // wt=7 is tram
        remainder_month_from_distance = (retire_distance_tram - td ) / dis_pm;
    }
    return remainder_month_from_distance;
}