# 積算距離超過判定ツール

Simutransにおいて、編成の積算距離が一定の値に到達することを判定するスクリプトです。

## 導入方法
pak/toolフォルダ内に空のフォルダを作成して、その中にダウンロードしたdescription.tabとtool.nutをコピーしてください。
標準の環境ではスクリプトツールをGUIで呼び出せないため、以下のメニューバー等を事前に導入してください。
(https://simutrans-portal.128-bit.net/users/27/rakuraku_menuicon_ver2_1)

## 使用方法
「スクリプトツール一覧」から、
- ボタン名 : 作成したファイル名
- タイトル : 積算距離超過判定ツール

を選択した後に、マップ上の任意のタイルをクリックしてください。
tool.nutの`display_restlife_less_than`に設定した残り月間までに、積算距離が`waytype`(自動車、鉄道、モノレール、市電)ごとに設定した値に到達する編成と、到達するまでの残り月間(予測値)がすべてメッセージボックスに表示されます。
メッセージボックスの座標は、抽出時点のその車両の座標です。

## 表示内容
各編成のメッセージボックスの表示内容は、以下の通りです。
| 行数 | 表示内容                                   |
| :---: | :---:                                     |
| 1 | 当該編成の名前                                |
| 2 | 当該編成が所属する路線の名前                  |
| 3 | 判定した車両の種類(Car,Train,Monorail,Tram)   |
| 4 | 積算距離到達までの残り月間                    |

## 設定方法
tool.nutの最初の`const`行に宣言されている値を変更することで、抽出する基準を変更できます。

### 定数について
使用した定数は以下のとおりです。
| 定数名                        | 説明 | 推奨値(pak128)|
|:---:                          |:---:|:---:|
| `retire_distance_car`         | 自動車の廃車基準距離|50000|
| `retire_distance_train`       | 鉄道の廃車基準距離|150000|
| `retire_distance_monorail`    | モノレールの廃車基準距離|100000|
| `retire_distance_tram`        | 市電の廃車基準距離|100000|
| `display_restlife_less_than`  | 残りこの月間未満で上記基準に到達する車両のみ表示|24|

## 走行距離について
走行開始から11ヶ月未満の編成および、設定していないwaytypeの車両は、一元的に内部的には残り32767ヶ月として扱っています。

## 既知の問題
- waytypeの仕様上、編成にない車両は抽出の対象外になります。

### License
The MIT License(https://licenses.opensource.jp/MIT/MIT.html)