include("lib_mark_v1");
include("builder");

template <- null
last_angle <- -1

local function _sort(a, b) {
  if (a < b) {
    return [a, b]
  } else {
    return [b, a]
  }
}

function select_area(player, x1, x2, y1, y2, z1, z2) {
  local ret = []
  local count = 0
  for (local x = x1; x <= x2; x++) {
    for (local y = y1; y <= y2; y++) {
      local found_way = false
      for (local z = z1; z <= z2; z++) {
        local mo1 = tile_x(x, y, z).find_object(mo_way)
        local mo2 = tile_x(x, y, z).find_object(mo_wayobj)
        local mo3 = tile_x(x, y, z).find_object(mo_building)
        local d1 = mo1 ? mo1.get_desc() : null
        local d2 = mo2 ? mo2.get_desc() : null
        local d3 = mo3 ? mo3.get_desc() : null
        ret.append([d1, d2, d3])
        if (d1 || d2 || d3) {
          found_way = true
        }
      }
      if (found_way) {
        count += 1
      }
    }
  }
  return {descs=ret, shape=[1 + x2 - x1, 1 + y2 - y1, 1 + z2 - z1], percentage=count/(1.0 * (x2 - x1 + 1) * (y2 - y1 + 1))}
}

function init(pl) {
  return true
}

function do_work(pl, start, end) {
  do_work_or_mark(pl, start, end, false)
}

function mark_tiles(pl, start, end) {
  if (!template) {
    mark(start, end)
  } else {
    do_work_or_mark(pl, start, end, true)
  }
}

function do_work_or_mark(pl, start, end, mark_only) {
  local work_direction_axis = "X";
  local x12 = _sort(start.x, end.x)
  local x1 = x12[0], x2 = x12[1]
  local y12 = _sort(start.y, end.y)
  local y1 = y12[0], y2 = y12[1]
  local z12 = _sort(start.z, end.z)
  local z1 = z12[0], z2 = z12[1]
  local first = false
  local diagonal_start = 0
  if (!template) {
    first = true
    // NS cross section of EW street
    local rety = select_area(pl, start.x, start.x, y1, y2, z1, z2 + 10)
    // EW cross section of NS street
    local retx = select_area(pl, x1, x2, start.y, start.y, z1, z2 + 10)
    if (retx.percentage > rety.percentage) {
      template = retx
      template.shape = [template.shape[0], template.shape[2]]
      work_direction_axis = "Y";
      if (!mark_only) {
        last_angle = (start.y < end.y) ? 6 : 2;
      }
    } else {
      template = rety
      template.shape = [template.shape[1], template.shape[2]]
      work_direction_axis = "X";
      if (!mark_only) {
        last_angle = (start.x < end.x) ? 4 : 0;
      }
    }
  } else {
    local angle = atan2(end.y - start.y, end.x - start.x);
    angle = ((angle / PI * 4) + 0.5 + 4).tointeger();
    work_direction_axis = ["X", "XY", "Y", "-XY", "X", "XY", "Y", "-XY", "X"][angle]
    if (last_angle != -1) {
      local a = angle - last_angle
      a = (a + 16) % 8
      if (a == 1) {
        diagonal_start = 1
      } else if (a == 7) {
        diagonal_start = -1
      } else {
        diagonal_start = 0
      }
      gui.add_message_at(pl, "angle diff <" + a + "> diagonal start: " + diagonal_start, coord(start.x, start.y));
    }
    if (!mark_only) {
      last_angle = angle
    }
  }
  if (!mark_only) {
    gui.add_message_at(pl, "範囲軌道敷設実行：" + work_direction_axis, coord(start.x, start.y));
  }

  local k = 0
  local w = template.shape[0]
  local h = mark_only ? 1 : template.shape[1]
  local builder = builder_x(pl)
  function work(p1, q1, r1, p2, q2, r2, d) {
      if (mark_only) {
          builder.set_marker()
          builder.move_to(p1, q1, r1).line_to(p2, q2, r2)
      } else {
        if (d[0]) {
          builder.set_way_tool(d[0])
          local dz = builder.is_elevated() ? -2 : 0
          builder.move_to(p1, q1, r1 + dz).line_to(p2, q2, r2 + dz)
        }
        if (d[1]) {
          builder.set_wayobj_tool(d[1])
          builder.move_to(p1, q1, r1).line_to(p2, q2, r2)
        }
        if (d[2]) {
          builder.set_station_tool(d[2])
          builder.move_to(p1, q1, r1).line_to(p2, q2, r2)
        }
      }
  }
  for (local i = 0; i < w; i++) {
    for (local j = 0; j < h; j++) {
      local d = template.descs[k]
      local p1, p2, q1, q2, r1, r2;
      if (work_direction_axis == "X") {
        if (first) {
          p1 = start.x;
          p2 = end.x;
          q1 = y1 + i;
          q2 = y1 + i;
        } else {
          local a = ((start.x < end.x) ? -1 : 1)
          p1 = start.x + a - diagonal_start * (w - i - 1);
          p2 = end.x;
          q1 = start.y - w + 1 + i;
          q2 = start.y - w + 1 + i;
        }
        r1 = start.z + j;
        r2 = end.z + j;
        work(p1, q1, r1, p2, q2, r2, d)
      } else if (work_direction_axis == "Y") {
        if (first) {
          p1 = x1 + i;
          p2 = x1 + i;
          q1 = start.y;
          q2 = end.y;
        } else {
          local a = ((start.y < end.y) ? -1 : 1)
          p1 = start.x - w + 1 + i;
          p2 = start.x - w + 1 + i;
          q1 = start.y + a + diagonal_start * (w - i - 1);
          q2 = end.y;
        }
        r1 = start.z + j;
        r2 = end.z + j;
        work(p1, q1, r1, p2, q2, r2, d)
      } else if (work_direction_axis == "XY") {
        local a = ((start.x < end.x) ? -1 : 1)
        local b = ((start.y < end.y) ? -1 : 1)
        local dx = end.x - start.x
        p1 = start.x + ((diagonal_start * a >= 0) ? 0 : w - 1) - i;
        p2 = start.x + ((diagonal_start * a >= 0) ? 0 : w - 1) - i + dx;
        q1 = start.y - ((diagonal_start * a >= 0) ? 0 : w - 1) + i;
        q2 = start.y - ((diagonal_start * a >= 0) ? 0 : w - 1) + i + dx;
        r1 = start.z + j;
        r2 = end.z + j;
        if (diagonal_start == -1) { 
          // inverse order
          local ia = w - 1 - i
          local p1a = start.x + ((diagonal_start * a >= 0) ? 0 : w - 1) - ia;
          local q1a = start.y - ((diagonal_start * a >= 0) ? 0 : w - 1) + ia;
          local p0 = p1a
          local q0 = start.y + b;
          work(p0, q0, r1, p1a, q1a, r1, d)
        } else if (diagonal_start == 1) {
          local p0 = start.x + a;
          local q0 = q1
          work(p0, q0, r1, p1, q1, r1, d)
        }
        work(p1, q1, r1, p2, q2, r2, d)
      } else if (work_direction_axis = "-XY") {
        local a = ((start.x < end.x) ? -1 : 1)
        local b = ((start.y < end.y) ? -1 : 1)
        local dx = end.x - start.x
        p1 = start.x + ((diagonal_start * a >= 0) ? 0 : - w + 1) + i;
        p2 = start.x + ((diagonal_start * a >= 0) ? 0 : - w + 1) + i + dx;
        q1 = start.y + ((diagonal_start * a >= 0) ? 0 : - w + 1) + i;
        q2 = start.y + ((diagonal_start * a >= 0) ? 0 : - w + 1) + i - dx;
        r1 = start.z + j;
        r2 = end.z + j;
        if (diagonal_start == 1) {
          local p0 = p1
          local q0 = start.y + b;
          work(p0, q0, r1, p1, q1, r1, d)
        } else if (diagonal_start == -1) {
          local p0 = start.x + a;
          local q0 = q1
          work(p0, q0, r1, p1, q1, r1, d)
        }
        work(p1, q1, r1, p2, q2, r2, d)
      }
      k++
    }
  }
}

function exit(pl)
{
	return true
}

function is_valid_pos(pl, pos, start) {
    return 2;
}
