class builder_x {
  _player = null
  _pos = null
  _tool = null
  _origin = null
  _tool_type = null
  waytypes = [wt_road, wt_rail, wt_water, wt_monorail, wt_maglev, wt_tram, wt_narrowgauge, wt_air, wt_power]
  systypes = [st_flat, st_elevated, st_runway, st_tram]
  constructor(pl) {
    if (pl instanceof player_x) {
      _player = pl
    } else {
      _player = player_x(pl)
    }
    _origin = coord3d(0, 0, 0)
    _pos = coord3d(0, 0, 0)
  }
  function is_elevated() {
    return _tool_type == "way" && _tool.get_system_type() == st_elevated
  }
  function set_marker() {
    _tool_type = "marker";
    return this
  }
  function set_station_tool(desc) {
    _tool = desc;
    _tool_type = "station";
    return this
  }
  function set_way_tool(desc) {
    _tool = desc;
    _tool_type = "way";
    return this
  }
  function set_wayobj_tool(desc) {
    _tool = desc;
    _tool_type = "wayobj";
    return this
  }
  function _coord3d(vargs) {
    return (vargs.len() == 1) ? vargs[0] : coord3d(vargs[0], vargs[1], vargs[2])
  }
  function set_origin(x, y, z) {
    _origin = coord3d(x, y, z)
    return this
  }
  function move_to(x, y, z) {
    _pos = coord3d(x, y, z)
    return this
  }
  function rel_move_to(x, y, z) {
    _pos = _pos + coord3d(x, y, z)
    return this
  }
  function line_to(...) {
    local end = _coord3d(vargv)
    if (_tool_type == "way") {
      command_x.build_way(_player, _pos + _origin, end + _origin, _tool, true)
    } else if (_tool_type == "wayobj") {
      command_x.build_wayobj(_player, _pos + _origin, end + _origin, _tool)
    } else if (_tool_type == "station") {
      local d = end - _pos;
      local dir_x = d.x > 0 ? 1 : -1
      local dir_y = d.y > 0 ? 1 : -1
      local dx = abs(d.x)
      local dy = abs(d.y)
      for (local i = 0; i <= dx; i++) {
        command_x.build_station(_player, _pos + _origin + coord3d(i * dir_x, 0, 0), _tool)
      }
      for (local i = 0; i <= dy; i++) {
        command_x.build_station(_player, _pos + _origin + coord3d(0, i * dir_y, 0), _tool)
      }
    } else if (_tool_type == "marker") {
        local d = end - _pos;
        local pos = _pos
        local dir_x = d.x > 0 ? 1 : -1
        local dir_y = d.y > 0 ? 1 : -1
        while ((pos.x != end.x) || (pos.y != end.y)) {
          if (pos.x != end.x) {
            pos.x += dir_x
            mark_tile(coord3d(pos.x, pos.y, _pos.z))
          }
          if (pos.y != end.y) {
            pos.y += dir_y
            mark_tile(coord3d(pos.x, pos.y, _pos.z))
          }
        }
    }
    _pos = end
    return this
  }
  function rel_line_to(...) {
    return line_to(_coord3d(vargv) + _pos)
  }
  function work_at(...) {
    local __pos = _coord3d(vargv)
    if (_tool_type == "station") {
      command_x.build_station(_player, __pos + _origin, _tool)
    }
    return this
  }
  function rel_work_at(...) {
    local __pos = _coord3d(vargv)
    return work_at(_pos + __pos)
  }
  function work() {
    return rel_work_at(0, 0, 0)
  }
}
