// factory moving tool
// author: himeshi (@himeshi_hob)
// April, 2022

// Due to factory_desc_x implementation, this tool is only for
// OTRP v32_1 or later.

function init(player)
{
	return true
}

function exit(player)
{
	return true
}

function is_coord_invalid(c) {
	return c.x == -1 && c.y == -1 && c.z == -1
}

function get_ground_pos(coord) {
	return square_x(coord.x, coord.y).get_ground_tile()
}

function find_factory(pos) {
	try {
		return factory_x(pos.x, pos.y)
	} catch (e) {
		// factory does not exists
		return null
	}
}

function do_work(player, start, end, keys) {
	local factory = find_factory(start)
	if(factory==null) {
		// although this should never happen...
		return "factory is not available."
	}
	
	// build new factory
	local bpm_factor = (1 << (world.get_bits_per_month() - 18))
	local build_param = format("1%i%i,%s", factory.get_rotate(), factory.get_base_production() * bpm_factor, factory.get_desc().get_name())
	local build_error = command_x(tool_build_factory).work(player, end, build_param)
	if(build_error!=null) {
		return build_error
	}
	
	// link the factory
	local link_tool = command_x(tool_link_factory)
	foreach(consumer in factory.get_consumers()) {
		link_tool.work(player, end, get_ground_pos(consumer), "")
	}
	foreach(supplier in factory.get_suppliers()) {
		link_tool.work(player, end, get_ground_pos(supplier), "")
	}
	
	// finally, remove old factory
	return command_x(tool_remover).work(player_x(1), start, "")
}

function mark_tiles(player, start, end, keys)
{
	mark_tile(start)
	
	local factory = find_factory(start)
	if(factory==null) {
		// although this should never happen...
		return
	}
	local size = factory.get_desc().get_building_desc().get_size(0)
	for(local dx=0; dx<size.x; dx+=1) {
		for(local dy=0; dy<size.y; dy+=1) {
			local pos = end + coord3d(dx, dy, 0)
			mark_tile(pos)
		}
	}
}

function is_valid_pos(player, pos, start)
{
	if(!is_coord_invalid(start)) {
		// the target factory is already determined.
		return 2
	}
	return (find_factory(pos) == null) ? 0 : 2
}
