# coding:utf-8
import argparse
from PIL import Image

def main(args):
    w = args.columns
    h = 1 + (args.n_images * args.repeat - 1) // w
    im = Image.open(args.filename_template.replace("%d", "{:02d}".format(0)))
    iw = im.width if args.advance_x == -1 else args.advance_x
    ih = im.height if args.advance_y == -1 else args.advance_y
    dest = Image.new(args.mode, (iw * w, ih * h))
    n = 0
    for i in range(args.n_images):
        for j in range(args.repeat):
            src = Image.open(args.filename_template.replace("%d", "{:02d}".format(i)))
            src_layer = Image.new(args.mode, (iw * w, ih * h))
            src_layer.paste(src, (args.offset_x + iw * (n % w), args.offset_y + ih * (n // w)))
            dest = Image.alpha_composite(dest, src_layer)
            n += 1
    dest.save(args.filename_template.replace("%d", "combined"))


if __name__ == '__main__':
    parser = argparse.ArgumentParser(description='description')
    parser.add_argument('filename_template', type=str, help='filenames of the images, with index numbers replaced by "%d".')
    parser.add_argument('n_images', type=int, help='number of images to combine')
    parser.add_argument('--columns', type=int, default=4, help='number of columns')
    parser.add_argument('--mode', type=str, default="RGBA", help='output type of images')
    parser.add_argument('--advance_x', type=int, default=-1, help='tiling width')
    parser.add_argument('--advance_y', type=int, default=-1, help='tiling height')
    parser.add_argument('--offset_x', type=int, default=0, help='tiling offset')
    parser.add_argument('--offset_y', type=int, default=0, help='tiling offset')
    parser.add_argument('--repeat', type=int, default=1, help='repeat images')
    args = parser.parse_args()
    main(args)
